<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" dir="{{ config('app.rtl') ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Admin') - {{ config('app.name') }}</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        :root {
            --sidebar-width: 260px;
            --header-height: 60px;
        }
        body { background-color: #f4f6f9; }
        .admin-sidebar {
            position: fixed;
            top: 0;
            left: 0;
            width: var(--sidebar-width);
            height: 100vh;
            background: #1a1c23;
            color: #fff;
            overflow-y: auto;
            z-index: 1000;
        }
        .admin-sidebar-header {
            padding: 15px 20px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            background: #161821;
        }
        .admin-sidebar-nav { padding: 15px 0; }
        .admin-sidebar-nav .nav-link {
            color: rgba(255,255,255,0.7);
            padding: 10px 20px;
            display: flex;
            align-items: center;
        }
        .admin-sidebar-nav .nav-link:hover,
        .admin-sidebar-nav .nav-link.active {
            color: #fff;
            background: rgba(255,255,255,0.1);
        }
        .admin-sidebar-nav .nav-link i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }
        .main-content {
            margin-left: var(--sidebar-width);
            min-height: 100vh;
            padding-top: var(--header-height);
        }
        .content-wrapper { padding: 20px; }
    </style>
    @stack('styles')
</head>
<body>
    <aside class="admin-sidebar">
        <div class="admin-sidebar-header">
            <a href="{{ route('admin.dashboard') }}" class="text-white text-decoration-none">
                <strong>{{ config('app.name') }} Admin</strong>
            </a>
        </div>
        <nav class="admin-sidebar-nav">
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a href="{{ route('admin.dashboard') }}" class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                        <i class="bi bi-speedometer2"></i> {{ __('dashboard') }}
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.users.index') }}" class="nav-link {{ request()->routeIs('admin.users.*') ? 'active' : '' }}">
                        <i class="bi bi-people"></i> {{ __('users') }}
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.packages.index') }}" class="nav-link {{ request()->routeIs('admin.packages.*') ? 'active' : '' }}">
                        <i class="bi bi-box"></i> {{ __('packages') }}
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.subscriptions.index') }}" class="nav-link {{ request()->routeIs('admin.subscriptions.*') ? 'active' : '' }}">
                        <i class="bi bi-credit-card"></i> {{ __('subscriptions') }}
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.transactions.index') }}" class="nav-link {{ request()->routeIs('admin.transactions.*') ? 'active' : '' }}">
                        <i class="bi bi-currency-dollar"></i> {{ __('transactions') }}
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.waservers.index') }}" class="nav-link {{ request()->routeIs('admin.waservers.*') ? 'active' : '' }}">
                        <i class="bi bi-hdd-network"></i> {{ __('wa_servers') }}
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.gateways.index') }}" class="nav-link {{ request()->routeIs('admin.gateways.*') ? 'active' : '' }}">
                        <i class="bi bi-router"></i> {{ __('gateways') }}
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.plugins.index') }}" class="nav-link {{ request()->routeIs('admin.plugins.*') ? 'active' : '' }}">
                        <i class="bi bi-puzzle"></i> {{ __('plugins') }}
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.vouchers.index') }}" class="nav-link {{ request()->routeIs('admin.vouchers.*') ? 'active' : '' }}">
                        <i class="bi bi-ticket"></i> {{ __('vouchers') }}
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.payouts.index') }}" class="nav-link {{ request()->routeIs('admin.payouts.*') ? 'active' : '' }}">
                        <i class="bi bi-wallet"></i> {{ __('payouts') }}
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.pages.index') }}" class="nav-link {{ request()->routeIs('admin.pages.*') ? 'active' : '' }}">
                        <i class="bi bi-file-earmark"></i> {{ __('pages') }}
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.roles.index') }}" class="nav-link {{ request()->routeIs('admin.roles.*') ? 'active' : '' }}">
                        <i class="bi bi-shield-lock"></i> {{ __('roles') }}
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.languages.index') }}" class="nav-link {{ request()->routeIs('admin.languages.*') ? 'active' : '' }}">
                        <i class="bi bi-globe"></i> {{ __('languages') }}
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.marketing.index') }}" class="nav-link {{ request()->routeIs('admin.marketing.*') ? 'active' : '' }}">
                        <i class="bi bi-megaphone"></i> {{ __('marketing') }}
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.settings.index') }}" class="nav-link {{ request()->routeIs('admin.settings.*') ? 'active' : '' }}">
                        <i class="bi bi-gear"></i> {{ __('settings') }}
                    </a>
                </li>
                <hr class="my-3 border-secondary">
                <li class="nav-item">
                    <a href="{{ route('dashboard') }}" class="nav-link">
                        <i class="bi bi-arrow-left"></i> {{ __('back_to_dashboard') }}
                    </a>
                </li>
            </ul>
        </nav>
    </aside>
    
    <div class="main-content">
        <header class="bg-white shadow-sm" style="height: var(--header-height); padding: 0 20px; display: flex; align-items: center; justify-content: flex-end;">
            <div class="dropdown">
                <button class="btn btn-link d-flex align-items-center" data-bs-toggle="dropdown">
                    <img src="{{ auth()->user()->avatar ?? asset('images/default-avatar.png') }}" class="rounded-circle me-2" width="32" height="32">
                    <span>{{ auth()->user()->name }}</span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <a class="dropdown-item" href="{{ route('profile') }}">{{ __('profile') }}</a>
                    <div class="dropdown-divider"></div>
                    <form action="{{ route('logout') }}" method="POST">
                        @csrf
                        <button type="submit" class="dropdown-item text-danger">{{ __('logout') }}</button>
                    </form>
                </div>
            </div>
        </header>
        
        <div class="content-wrapper">
            @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            @endif
            
            @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            @endif
            
            @yield('content')
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    @stack('scripts')
</body>
</html>
