<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ $title ?? 'المراسل' }} - {{ config('app.name') }}</title>
    
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Remix Icons -->
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    
    <!-- Bootstrap 5 RTL -->
    @if(app()->getLocale() == 'ar')
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    @else
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    @endif
    
    <style>
        :root {
            --sidebar-width: 340px;
            --header-height: 70px;
            --primary-color: #25D366;
        }
        
        body {
            font-family: 'Cairo', sans-serif;
            background-color: #f0f2f5;
            overflow: hidden;
        }
        
        .main-layout {
            display: flex;
            height: 100vh;
        }
        
        .sidebar {
            width: var(--sidebar-width);
            background: #fff;
            border-right: 1px solid #e0e0e0;
            display: flex;
            flex-direction: column;
        }
        
        [dir="rtl"] .sidebar {
            border-right: none;
            border-left: 1px solid #e0e0e0;
        }
        
        .sidebar-header {
            padding: 15px 20px;
            background: #f0f2f5;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .sidebar-body {
            flex: 1;
            overflow-y: auto;
        }
        
        .conversation-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        
        .conversation-item a {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            text-decoration: none;
            color: inherit;
            border-bottom: 1px solid #f0f2f5;
            transition: background 0.2s;
        }
        
        .conversation-item a:hover,
        .conversation-item.active a {
            background: #f0f2f5;
        }
        
        .conversation-item .avatar {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            overflow: hidden;
            margin-left: 15px;
            position: relative;
        }
        
        [dir="ltr"] .conversation-item .avatar {
            margin-left: 0;
            margin-right: 15px;
        }
        
        .conversation-item .avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .conversation-content {
            flex: 1;
            min-width: 0;
        }
        
        .conversation-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .main {
            flex: 1;
            display: flex;
            flex-direction: column;
            background: #fff;
        }
        
        .chat-body {
            display: flex;
            flex-direction: column;
            height: 100%;
        }
        
        .chat-header {
            background: #f0f2f5;
        }
        
        .chat-content {
            flex: 1;
            overflow-y: auto;
            background: #e5ddd5;
            background-image: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23d4d4d4' fill-opacity='0.4'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
        }
        
        .message {
            display: flex;
            margin-bottom: 10px;
        }
        
        .message-received {
            justify-content: flex-start;
        }
        
        .message-sent {
            justify-content: flex-end;
        }
        
        .message-wrapper {
            max-width: 65%;
            padding: 8px 12px;
            border-radius: 8px;
            position: relative;
        }
        
        .message-received .message-wrapper {
            background: #fff;
            border-top-left-radius: 0;
        }
        
        [dir="rtl"] .message-received .message-wrapper {
            border-top-left-radius: 8px;
            border-top-right-radius: 0;
        }
        
        .message-sent .message-wrapper {
            background: #d9fdd3;
            border-top-right-radius: 0;
        }
        
        [dir="rtl"] .message-sent .message-wrapper {
            border-top-right-radius: 8px;
            border-top-left-radius: 0;
        }
        
        .message-content p {
            margin: 0;
            word-wrap: break-word;
        }
        
        .message-meta {
            display: flex;
            justify-content: flex-end;
            align-items: center;
            gap: 4px;
            margin-top: 4px;
        }
        
        .message-meta .time {
            font-size: 11px;
            color: #667781;
        }
        
        .chat-footer {
            background: #f0f2f5;
        }
        
        .avatar-clickable {
            cursor: pointer;
        }
        
        .scroll-to-bottom-btn {
            position: fixed;
            bottom: 100px;
            right: 30px;
            width: 44px;
            height: 44px;
            border-radius: 50%;
            background: #fff;
            border: 1px solid #ddd;
            box-shadow: 0 3px 12px rgba(0,0,0,0.2);
            display: none;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            z-index: 1000;
        }
        
        .scroll-to-bottom-btn.visible {
            display: flex;
        }
        
        [dir="rtl"] .scroll-to-bottom-btn {
            right: auto;
            left: 30px;
        }
        
        @media (max-width: 1199px) {
            .sidebar {
                position: fixed;
                left: 0;
                top: 0;
                height: 100%;
                transform: translateX(-100%);
                transition: transform 0.3s;
                z-index: 1050;
            }
            
            [dir="rtl"] .sidebar {
                left: auto;
                right: 0;
                transform: translateX(100%);
            }
            
            .sidebar.show {
                transform: translateX(0);
            }
        }
    </style>
    
    @stack('styles')
</head>
<body>
    @yield('content')

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    @stack('scripts')
</body>
</html>
