@extends('layouts.messenger')

@section('content')
<div class="main-layout">
    @include('messenger.partials.sidebar')
    
    <script>
        window.messengerHideNumbers = {{ $hideNumbers ? 'true' : 'false' }};
        window.messengerMaskedPhone = '{{ $contact->phone_display ?? $contact->phone }}';
    </script>

    <main class="main">
        <div class="chat-body" id="chatBody">
            <!-- Chat Header -->
            <div class="chat-header border-bottom py-3 px-4">
                <div class="row align-items-center">
                    <div class="col-auto">
                        <button class="btn btn-light d-xl-none" data-toggle="sidebar">
                            <i class="ri-menu-line"></i>
                        </button>
                    </div>
                    <div class="col-auto">
                        <div class="avatar avatar-clickable" data-toggle="modal" data-target="#profilePicModal">
                            <img class="avatar-img" src="{{ $contact->wa_profile_pic ?? asset('images/default-avatar.png') }}">
                        </div>
                    </div>
                    <div class="col">
                        <h5 class="mb-0">{{ $contact->wa_name ?? $contact->phone_display }}</h5>
                        <small class="text-muted">{{ $contact->phone_display }}</small>
                    </div>
                    <div class="col-auto chat-header-actions">
                        <button class="btn btn-light btn-sm" id="refreshChat" title="تحديث">
                            <i class="ri-refresh-line"></i>
                        </button>
                        <button class="btn btn-light btn-sm" id="searchMessages" title="بحث">
                            <i class="ri-search-line"></i>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Chat Content -->
            <div class="chat-content p-4" id="chatContent">
                @foreach($messages as $message)
                    @if($message->type === 'received')
                        <div class="message message-received" data-id="{{ $message->id }}">
                            <div class="message-wrapper">
                                <div class="message-content">
                                    @if($message->media_url)
                                        <img src="{{ $message->media_url }}" class="img-fluid rounded mb-2">
                                    @endif
                                    <p>{{ $message->message }}</p>
                                </div>
                                <div class="message-meta">
                                    <span class="time">{{ $message->receive_date->format('H:i') }}</span>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="message message-sent" data-id="{{ $message->id }}">
                            <div class="message-wrapper">
                                <div class="message-content">
                                    @if($message->media_url)
                                        <img src="{{ $message->media_url }}" class="img-fluid rounded mb-2">
                                    @endif
                                    <p>{{ $message->message }}</p>
                                </div>
                                <div class="message-meta">
                                    <span class="time">{{ $message->create_date->format('H:i') }}</span>
                                    @if($message->status == 5)
                                        <i class="ri-check-double-line text-primary" title="مقروء"></i>
                                    @elseif($message->status >= 3)
                                        <i class="ri-check-double-line" title="مستلم"></i>
                                    @else
                                        <i class="ri-check-line" title="مرسل"></i>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>

            <!-- Scroll to bottom button -->
            <button class="scroll-to-bottom-btn" id="scrollToBottom">
                <i class="ri-arrow-down-line"></i>
                <span class="new-messages-badge"></span>
            </button>

            <!-- Chat Footer -->
            <div class="chat-footer border-top p-4">
                <form id="sendMessageForm">
                    @csrf
                    <input type="hidden" name="phone" value="{{ $contact->phone }}">
                    <input type="hidden" name="account_id" value="{{ $account->id }}">
                    
                    <div class="input-group">
                        <button type="button" class="btn btn-light" id="attachBtn">
                            <i class="ri-attachment-line"></i>
                        </button>
                        <input type="text" name="message" class="form-control" placeholder="اكتب رسالة..." id="messageInput">
                        <button type="button" class="btn btn-light" id="emojiBtn">
                            <i class="ri-emotion-happy-line"></i>
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <i class="ri-send-plane-2-fill"></i>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </main>
</div>

<!-- Profile Picture Modal -->
<div class="modal fade profile-pic-modal" id="profilePicModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="close-modal" data-dismiss="modal">&times;</button>
                <img src="{{ $contact->wa_profile_pic ?? asset('images/default-avatar.png') }}" alt="Profile">
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const chatContent = document.getElementById('chatContent');
    const scrollToBottomBtn = document.getElementById('scrollToBottom');
    const messageForm = document.getElementById('sendMessageForm');
    
    // Scroll to bottom on load
    chatContent.scrollTop = chatContent.scrollHeight;
    
    // Show/hide scroll to bottom button
    chatContent.addEventListener('scroll', function() {
        const isNearBottom = chatContent.scrollHeight - chatContent.scrollTop - chatContent.clientHeight < 200;
        scrollToBottomBtn.classList.toggle('visible', !isNearBottom);
    });
    
    scrollToBottomBtn.addEventListener('click', function() {
        chatContent.scrollTop = chatContent.scrollHeight;
    });
    
    // Send message
    messageForm.addEventListener('submit', function(e) {
        e.preventDefault();
        const messageInput = document.getElementById('messageInput');
        const message = messageInput.value.trim();
        
        if (!message) return;
        
        fetch('{{ route("messenger.send") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                phone: '{{ $contact->phone }}',
                account_id: '{{ $account->id }}',
                message: message
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                messageInput.value = '';
                // Add message to chat
                const msgDiv = document.createElement('div');
                msgDiv.className = 'message message-sent';
                msgDiv.innerHTML = `
                    <div class="message-wrapper">
                        <div class="message-content"><p>${message}</p></div>
                        <div class="message-meta">
                            <span class="time">${new Date().toLocaleTimeString('ar', {hour: '2-digit', minute: '2-digit'})}</span>
                            <i class="ri-check-line"></i>
                        </div>
                    </div>
                `;
                chatContent.appendChild(msgDiv);
                chatContent.scrollTop = chatContent.scrollHeight;
            }
        });
    });
});
</script>
@endpush
