<aside class="sidebar">
    <div class="sidebar-header">
        <div class="row align-items-center">
            <div class="col">
                <h5 class="mb-0">المحادثات</h5>
            </div>
            <div class="col-auto">
                <a href="{{ route('dashboard') }}" class="btn btn-light btn-sm">
                    <i class="ri-dashboard-line"></i>
                </a>
            </div>
        </div>
    </div>

    <div class="sidebar-search px-3 py-2">
        <div class="input-group">
            <span class="input-group-text bg-transparent border-end-0">
                <i class="ri-search-line"></i>
            </span>
            <input type="text" class="form-control border-start-0" id="searchConversations" placeholder="بحث...">
        </div>
    </div>

    <div class="sidebar-body">
        <ul class="conversation-list" id="conversationList">
            @forelse($conversations as $conversation)
                <li class="conversation-item {{ request()->segment(3) == $conversation->phone ? 'active' : '' }}">
                    <a href="{{ route('messenger.chat', ['phone' => $conversation->phone]) }}">
                        <div class="avatar">
                            <img src="{{ $conversation->wa_profile_pic ?? asset('images/default-avatar.png') }}" alt="">
                            @if($conversation->unread_count > 0)
                                <span class="badge-status badge-success"></span>
                            @endif
                        </div>
                        <div class="conversation-content">
                            <div class="conversation-header">
                                <h6 class="mb-0">{{ $conversation->wa_name ?? $conversation->phone_display }}</h6>
                                <small class="text-muted">{{ $conversation->last_message_time->diffForHumans() }}</small>
                            </div>
                            <p class="text-muted text-truncate mb-0">{{ Str::limit($conversation->last_message, 40) }}</p>
                        </div>
                        @if($conversation->unread_count > 0)
                            <span class="badge bg-primary rounded-pill">{{ $conversation->unread_count }}</span>
                        @endif
                    </a>
                </li>
            @empty
                <li class="text-center text-muted py-5">
                    <i class="ri-chat-3-line ri-3x mb-2"></i>
                    <p>لا توجد محادثات</p>
                </li>
            @endforelse
        </ul>
    </div>
</aside>
