@extends('layouts.app')

@section('title', __('misc_packages_title'))

@section('content')
<div class="container py-5">
    <div class="text-center mb-5">
        <h1>{{ __('misc_packages_title') }}</h1>
        <p class="text-muted">{{ __('choose_best_plan') }}</p>
    </div>
    
    <div class="row justify-content-center">
        @forelse($packages ?? [] as $package)
        <div class="col-md-4 mb-4">
            <div class="card h-100 {{ $package->featured ? 'border-primary' : '' }}">
                @if($package->featured)
                <div class="card-header bg-primary text-white text-center">
                    <span class="badge bg-warning">{{ __('most_popular') }}</span>
                </div>
                @endif
                <div class="card-body text-center">
                    <h3 class="card-title">{{ $package->name }}</h3>
                    <div class="display-4 my-3">
                        {{ $settings['currency'] ?? '$' }}{{ number_format($package->price, 2) }}
                        <small class="text-muted fs-6">/{{ $package->duration }} {{ __('days') }}</small>
                    </div>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            {{ $package->send_limit ?: __('unlimited') }} {{ __('messages') }}
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            {{ $package->device_limit ?: __('unlimited') }} {{ __('devices') }}
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            {{ $package->contact_limit ?: __('unlimited') }} {{ __('contacts') }}
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            {{ $package->wa_account_limit ?: __('unlimited') }} {{ __('wa_accounts') }}
                        </li>
                        @php $services = explode(',', $package->services ?? ''); @endphp
                        @if(in_array('api', $services))
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            {{ __('api_access') }}
                        </li>
                        @endif
                        @if(in_array('webhooks', $services))
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            {{ __('webhooks') }}
                        </li>
                        @endif
                    </ul>
                </div>
                <div class="card-footer bg-transparent border-0 text-center pb-4">
                    @auth
                    <a href="{{ route('dashboard.subscribe', $package->id) }}" class="btn btn-{{ $package->featured ? 'primary' : 'outline-primary' }} btn-lg w-100">
                        {{ __('subscribe_now') }}
                    </a>
                    @else
                    <a href="{{ route('register') }}" class="btn btn-{{ $package->featured ? 'primary' : 'outline-primary' }} btn-lg w-100">
                        {{ __('get_started') }}
                    </a>
                    @endauth
                </div>
            </div>
        </div>
        @empty
        <div class="col-12 text-center">
            <div class="alert alert-info">
                {{ __('no_packages_available') }}
            </div>
        </div>
        @endforelse
    </div>
</div>
@endsection
