@extends('layouts.app')

@section('title', __('misc_partnerrates_title'))

@section('content')
<div class="container py-5">
    <div class="text-center mb-5">
        <h1>{{ __('misc_partnerrates_title') }}</h1>
        <p class="text-muted">{{ __('partner_rates_subtitle') }}</p>
    </div>
    
    <div class="card">
        <div class="card-body">
            <div class="mb-4">
                <input type="text" class="form-control" id="searchCountry" placeholder="{{ __('search_country') }}">
            </div>
            
            <div class="table-responsive">
                <table class="table table-striped" id="partnerRatesTable">
                    <thead>
                        <tr>
                            <th>{{ __('country') }}</th>
                            <th>{{ __('code') }}</th>
                            <th>{{ __('earning_per_sms') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($partnerRates ?? [] as $country => $rate)
                        <tr>
                            <td>{{ $country }}</td>
                            <td>{{ $rate['code'] ?? '' }}</td>
                            <td>{{ $settings['currency'] ?? '$' }}{{ number_format($rate['earning'] ?? 0, 4) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.getElementById('searchCountry').addEventListener('input', function() {
    const filter = this.value.toLowerCase();
    const rows = document.querySelectorAll('#partnerRatesTable tbody tr');
    rows.forEach(row => {
        const text = row.textContent.toLowerCase();
        row.style.display = text.includes(filter) ? '' : 'none';
    });
});
</script>
@endpush
@endsection
