<!-- Add AI Plugin Modal -->
<div class="modal fade" id="addAiPluginModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('add_ai_plugin') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('dashboard.ai.plugins.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('name') }}</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('ai_key') }}</label>
                            <select name="ai_key_id" class="form-control" required>
                                @foreach($aiKeys ?? [] as $key)
                                <option value="{{ $key->id }}">{{ $key->name ?? $key->provider }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('model') }}</label>
                            <input type="text" name="model" class="form-control" placeholder="gpt-4, claude-3, etc." required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('trigger') }}</label>
                            <input type="text" name="trigger" class="form-control" placeholder="{{ __('keyword_or_regex') }}">
                        </div>
                        <div class="col-12 mb-3">
                            <label class="form-label">{{ __('system_prompt') }}</label>
                            <textarea name="system_prompt" class="form-control" rows="4" placeholder="{{ __('ai_system_prompt_hint') }}"></textarea>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('max_tokens') }}</label>
                            <input type="number" name="max_tokens" class="form-control" value="500">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('temperature') }}</label>
                            <input type="number" name="temperature" class="form-control" value="0.7" step="0.1" min="0" max="2">
                        </div>
                        <div class="col-12">
                            <div class="form-check">
                                <input type="checkbox" name="status" class="form-check-input" value="1" checked>
                                <label class="form-check-label">{{ __('active') }}</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
