<!-- Add API Key Modal -->
<div class="modal fade" id="addApiKeyModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('add_api_key') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('dashboard.keys.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('name') }}</label>
                        <input type="text" name="name" class="form-control" placeholder="{{ __('api_key_name_hint') }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('permissions') }}</label>
                        <div class="row">
                            <div class="col-6">
                                <div class="form-check">
                                    <input type="checkbox" name="permissions[]" class="form-check-input" value="send_sms" checked>
                                    <label class="form-check-label">{{ __('send_sms') }}</label>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-check">
                                    <input type="checkbox" name="permissions[]" class="form-check-input" value="send_whatsapp" checked>
                                    <label class="form-check-label">{{ __('send_whatsapp') }}</label>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-check">
                                    <input type="checkbox" name="permissions[]" class="form-check-input" value="read_messages">
                                    <label class="form-check-label">{{ __('read_messages') }}</label>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-check">
                                    <input type="checkbox" name="permissions[]" class="form-check-input" value="manage_contacts">
                                    <label class="form-check-label">{{ __('manage_contacts') }}</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('generate_key') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
