<!-- Add Webhook Modal -->
<div class="modal fade" id="addWebhookModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('add_webhook') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('dashboard.webhooks.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('name') }}</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('url') }}</label>
                        <input type="url" name="url" class="form-control" placeholder="https://..." required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('events') }}</label>
                        <div class="row">
                            <div class="col-6">
                                <div class="form-check">
                                    <input type="checkbox" name="events[]" class="form-check-input" value="message.received">
                                    <label class="form-check-label">{{ __('message_received') }}</label>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-check">
                                    <input type="checkbox" name="events[]" class="form-check-input" value="message.sent">
                                    <label class="form-check-label">{{ __('message_sent') }}</label>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-check">
                                    <input type="checkbox" name="events[]" class="form-check-input" value="message.failed">
                                    <label class="form-check-label">{{ __('message_failed') }}</label>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-check">
                                    <input type="checkbox" name="events[]" class="form-check-input" value="device.status">
                                    <label class="form-check-label">{{ __('device_status') }}</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('secret') }} ({{ __('optional') }})</label>
                        <input type="text" name="secret" class="form-control">
                        <small class="text-muted">{{ __('webhook_secret_hint') }}</small>
                    </div>
                    <div class="form-check">
                        <input type="checkbox" name="status" class="form-check-input" value="1" checked>
                        <label class="form-check-label">{{ __('active') }}</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
