<!-- Import Contacts Modal -->
<div class="modal fade" id="importContactsModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('import_contacts') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('dashboard.contacts.import') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('file') }}</label>
                        <input type="file" name="file" class="form-control" accept=".xlsx,.xls,.csv" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('assign_to_group') }}</label>
                        <select name="group" class="form-control">
                            <option value="">{{ __('none') }}</option>
                            @foreach($groups ?? [] as $group)
                            <option value="{{ $group->id }}">{{ $group->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="alert alert-info">
                        <strong>{{ __('file_format') }}:</strong>
                        <ul class="mb-0">
                            <li>Column A: {{ __('name') }}</li>
                            <li>Column B: {{ __('phone') }}</li>
                            <li>Column C: {{ __('email') }} ({{ __('optional') }})</li>
                        </ul>
                        <a href="{{ asset('templates/contacts_template.xlsx') }}" class="btn btn-sm btn-outline-info mt-2">
                            <i class="bi bi-download"></i> {{ __('download_template') }}
                        </a>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-upload"></i> {{ __('import') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
