<!-- SMS Quick Message Modal -->
<div class="modal fade" id="smsQuickModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('quick_sms') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('dashboard.sms.send') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('device') }}</label>
                        <select name="device" class="form-control" required>
                            @foreach($devices ?? [] as $device)
                            <option value="{{ $device->id }}">{{ $device->name }} ({{ $device->phone }})</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('recipient') }}</label>
                        <input type="text" name="phone" class="form-control" placeholder="+1234567890" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('message') }}</label>
                        <textarea name="message" class="form-control" rows="4" maxlength="160" required></textarea>
                        <small class="text-muted"><span id="charCount">0</span>/160 {{ __('characters') }}</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-send"></i> {{ __('send') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
