<!-- User Settings Modal -->
<div class="modal fade" id="userSettingsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('user_settings') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('dashboard.profile.update') }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <ul class="nav nav-tabs" id="settingsTab">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#profileTab">{{ __('profile') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#securityTab">{{ __('security') }}</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#preferencesTab">{{ __('preferences') }}</a>
                        </li>
                    </ul>
                    
                    <div class="tab-content mt-3">
                        <div class="tab-pane fade show active" id="profileTab">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">{{ __('name') }}</label>
                                    <input type="text" name="name" class="form-control" value="{{ auth()->user()->name }}" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">{{ __('email') }}</label>
                                    <input type="email" name="email" class="form-control" value="{{ auth()->user()->email }}" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">{{ __('phone') }}</label>
                                    <input type="text" name="phone" class="form-control" value="{{ auth()->user()->phone }}">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">{{ __('avatar') }}</label>
                                    <input type="file" name="avatar" class="form-control" accept="image/*">
                                </div>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" id="securityTab">
                            <div class="row">
                                <div class="col-12 mb-3">
                                    <label class="form-label">{{ __('current_password') }}</label>
                                    <input type="password" name="current_password" class="form-control">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">{{ __('new_password') }}</label>
                                    <input type="password" name="new_password" class="form-control">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">{{ __('confirm_password') }}</label>
                                    <input type="password" name="new_password_confirmation" class="form-control">
                                </div>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" id="preferencesTab">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">{{ __('language') }}</label>
                                    <select name="language" class="form-control">
                                        @foreach($languages ?? [] as $lang)
                                        <option value="{{ $lang->id }}" {{ auth()->user()->language == $lang->id ? 'selected' : '' }}>{{ $lang->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">{{ __('timezone') }}</label>
                                    <select name="timezone" class="form-control">
                                        @foreach(timezone_identifiers_list() as $tz)
                                        <option value="{{ $tz }}" {{ auth()->user()->timezone == $tz ? 'selected' : '' }}>{{ $tz }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-12">
                                    <div class="form-check">
                                        <input type="checkbox" name="alertsound" class="form-check-input" value="1" {{ auth()->user()->alertsound ? 'checked' : '' }}>
                                        <label class="form-check-label">{{ __('notification_sounds') }}</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
