<!-- WhatsApp Excel Import Modal -->
<div class="modal fade" id="whatsappExcelModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('import_from_excel') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('dashboard.whatsapp.import') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('account') }}</label>
                        <select name="account" class="form-control" required>
                            @foreach($waAccounts ?? [] as $account)
                            <option value="{{ $account->unique }}">{{ $account->name ?? $account->phone }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('excel_file') }}</label>
                        <input type="file" name="file" class="form-control" accept=".xlsx,.xls,.csv" required>
                        <small class="text-muted">{{ __('excel_format_hint') }}</small>
                    </div>
                    <div class="alert alert-info">
                        <strong>{{ __('excel_columns') }}:</strong>
                        <ul class="mb-0">
                            <li>Column A: {{ __('phone_number') }}</li>
                            <li>Column B: {{ __('message') }}</li>
                        </ul>
                        <a href="{{ asset('templates/bulk_template.xlsx') }}" class="btn btn-sm btn-outline-info mt-2">
                            <i class="bi bi-download"></i> {{ __('download_template') }}
                        </a>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('cancel') }}</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-upload"></i> {{ __('import') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
